<?php 

/* 
 -- =============================================
-- Author:			<Emmanuel Gabion>
-- Create date: 	<11/5/2013>
-- Last Modified: 	<11/5/2013>
-- Description:		< Additional generic Functions Requested for optimal database usage>
-- =============================================
  */
 
if ( ! defined('BASEPATH')) exit('No direct script access allowed');
include('accesstemplate.php');

// class Generic extends CI_Controller {
class Generic_mod extends AccessTemplate {
	
	public function __construct(){
		parent::__construct();
		$this->load->model('api_seatplans_model', 'seatplans');
		$this->load->model('api_events_model', 'events');
		$this->load->model('api_sections_model', 'sections');
		$this->load->model('api_transaction_model', 'transaction');
		$this->load->model('api_events_model', 'events');
		$this->load->model('api_prices_model', 'prices');
		$this->load->model('api_tickets_model', 'tickets');
		$this->load->model('api_payments_model', 'payments');
		$this->load->model('api_ticket_types_model', 'ticket_types');
		$this->load->model('api_ip_model', 'ip');
		$this->load->model('api_ticket_layouts_model', 'ticket_layouts');
		$this->load->model('api_bcode_model', 'bcode');
		$this->load->model('api_promo_codes_model', 'promo');
		$this->load->model('api_authentication_model', 'authentication');
		$this->load->database('default',true); 
	}
	
	function template() {
			
		// the date today
		$today = date("Y-m-d");
		$today = '2013-02-11';
		
		
		
		$dbAccess->select("
				evt.event_code
				, evt.event_title
				, evt.event_long_title
				, evt.event_date_time
			");
			
		$dbAccess->where("evt.event_date_time > '$today 00:00:00'");
		$dbAccess->where("evt.event_date_time < '$today 23:59:59'");
		$dbAccess->where("evt.event_active", 1);
		$query = $dbAccess->get('events evt');
	
	
		$this->load->dbutil();
		
		$config = array (
			  'root'    => 'root',
			  'element' => 'sections', 
			  'newline' => "\n", 
			  'tab'    => "\t"
			);

			
		$xmloutput = $this->dbutil->xml_from_result($query, $config);
		echo $xmloutput;

	}
	

	var $errorMessage = array (
		'ER:00' => 'Incomplete/Invalid Parameters.',
		'ER:01' => 'Invalid access.',
		'ER:02' => 'Inactive KEY',
		'ER:04' => 'In',
		'ER:05' => 'Relay problem and error encountered while storing data. Please contact MGI.',
		'ER:06' => 'Relay problem and error encountered while storing data. Please contact MGI.',
		);
	
	//============================== D A T A S Y N C  M O D E  =======================================
	//======= P a r t y L i n e   A u t h e n t i c a t i o n   P r o t o c o l =======
	 			 

		/* 	GetActiveEventsFullMarket_NoDesc()||CREATE DATE: <11/5/2013>||LAST MODIFIED: <11/5/2013>
			Description: List of full details of Active events from 'market' database minus the event description */
		function GetActiveEventsFullMarket_NoDesc(){
		
			$appcode = $this->input->get_post('appcode');
			$livetoken = $this->input->get_post('livetoken');
			$event_id = $this->input->get_post('eventid');
			
			if(!$appcode){
				$this->promptError('ER:01:03');
			}elseif(!$livetoken){
				$this->promptError('ER:01:04');
			}else{
			
				// Checks the existence of $appcode && $livetoken
				if (!$this->validatesession($appcode,$livetoken))
				{
					// echo 'Invalid key pair';
					$this->promptError('ER:02:02');
				}
				
				// Check if Expired..if not yet expired..if not...
				elseif($this->checksessionexpiration($appcode,$livetoken))
					{ 
						// echo 'LiveToken expired';
						$this->promptError('ER:03:01');
					}
					else{	 

				$dbAccess = $this->load->database('market',true);
			
			$queryString = "SELECT 
			`evt`.`event_id`
			, `evt`.`event_code`
			, `evt`.`event_long_title`
			, `evt`.`event_date_time`
			,  evt.event_image
			,  evt.event_image_1
			, `evt`.`event_seatplan_id`
			, `evt`.`event_recommended`
			, `s`.`seatplan_image`
			, `evt`.`event_venue_id`
			, `evt`.`event_internet_sales_charge` as convenience_charge
			, `evt`.`event_type`
			, `ec`.`events_config_ekbarcode_active` 		
			, `evt`.`event_active`
			, `evt`.`event_ticket_types`
			, `evt`.`event_hotel`
			, `evt`.`event_always_show`
			, `evt`.`event_online_registration`
			FROM (`events` evt) 
			LEFT JOIN `events_config` ec ON `ec`.`events_config_eventid` = `evt`.`event_id` 
			LEFT JOIN `seatplans` s ON `s`.`seatplan_id` = `evt`.`event_seatplan_id` 
			WHERE `evt`.`event_active` = 1 and event_date_time >= now()";
			
			
		if($event_id){
		$queryString = $queryString . " and `evt`.`event_id`  = $event_id";
		}
		
			
			$query = $dbAccess->query($queryString);
			$data['eventDetails'] = $query->result();
			
				//display the page
				$this->load->view('event_details_xml_NoDesc', $data);
			 }
		 }

		}
		/* End of GetActiveEventsFullMarket_NoDesc() */
		
		
		
		/* 	GetActiveEventsbyType()||CREATE DATE: <11/5/2013>||LAST MODIFIED: <11/5/2013>
		Description: List of basic details of Active events from 'market' database BY EVENT TYPE and minus event description */
		function GetActiveEventsbyType(){
		
			$appcode = $this->input->get_post('appcode');
			$livetoken = $this->input->get_post('livetoken');
			$event_type = $this->input->get_post('type');
			
			if(!$appcode){
				$this->promptError('ER:01:03');
			}elseif(!$livetoken){
				$this->promptError('ER:01:04');			
			}elseif(!$event_type){
				$this->promptError('ER:05:18');
			}else{
				
					// Checks the existence of $appcode && $livetoken
					if (!$this->validatesession($appcode,$livetoken))
					{$this->promptError('ER:02:02');}
					
					// Check if Expired..if not yet expired..if not...
					elseif($this->checksessionexpiration($appcode,$livetoken))
						{ $this->promptError('ER:03:01');}
			
					else{	

						$dbAccess = $this->load->database('market',true);


						$queryString = "SELECT 
								evt.event_id
								,evt.event_code
								, evt.event_title
								, evt.event_long_title
								, evt.event_date_time
								, evt.event_internet_sales_charge as convenience_charge
								, ec.events_config_ekbarcode_active
								FROM (`events` evt) 
								LEFT JOIN `events_config` ec ON `ec`.`events_config_eventid` = `evt`.`event_id` 
								LEFT JOIN `seatplans` s ON `s`.`seatplan_id` = `evt`.`event_seatplan_id` 
								WHERE `evt`.`event_active` = 1 and event_date_time >= now() and `evt`.event_type = '$event_type'";
					
			$query = $dbAccess->query($queryString);
			$data['eventDetails'] = $query->result();

						//display the page
						$this->load->view('active_events_xml', $data);
						
					}
			}
		}
		/* End of GetActiveEventsbyType() */
		

		/* 	GetSchedbyEventID()||CREATE DATE: <11/5/2013>||LAST MODIFIED: <11/5/2013>
			Description: List of event id and their event date from 'market' database BY event id*/
		function GetSchedbyEventID(){
	
		$appcode = $this->input->get_post('appcode');
		$livetoken = $this->input->get_post('livetoken');
		$event_id = $this->input->get_post('eventid');
		
		if(!$appcode){
			$this->promptError('ER:01:03');
		}elseif(!$livetoken){
			$this->promptError('ER:01:04');			
		}elseif(!$event_id){
			$this->promptError('ER:05:03');
		}else{
			
				// Checks the existence of $appcode && $livetoken
				if (!$this->validatesession($appcode,$livetoken))
				{$this->promptError('ER:02:02');}
				
				// Check if Expired..if not yet expired..if not...
				elseif($this->checksessionexpiration($appcode,$livetoken))
					{ $this->promptError('ER:03:01');}
		
				else{	

					$dbAccess = $this->load->database('market',true);


					$queryString = "SELECT 
							evt.event_id
							, evt.event_date_time
							FROM (`events` evt) 
							LEFT JOIN `events_config` ec ON `ec`.`events_config_eventid` = `evt`.`event_id` 
							LEFT JOIN `seatplans` s ON `s`.`seatplan_id` = `evt`.`event_seatplan_id` 
							WHERE `evt`.`event_active` = 1 and event_date_time >= now()  and `evt`.`event_id` =  '$event_id' ";
				
		$query = $dbAccess->query($queryString);
		$data['eventDetails'] = $query->result();

					//display the page
					$this->load->view('active_events_sched', $data);
					
				}
		}
	}
		/* End of GetSchedbyEventID() */
	
	
		/* 	GetPriceSectionbyID()||CREATE DATE: <11/5/2013>||LAST MODIFIED: <11/5/2013>
			Description: List of Prices and their Sections by Price ID */
		function GetPriceSectionbyID(){
			
				$price_id = $this->input->get_post('priceid');
				$appcode = $this->input->get_post('appcode');
				$livetoken = $this->input->get_post('livetoken');
				
				if(!$appcode){
					$this->promptError('ER:01:03');
				}elseif(!$livetoken){
					$this->promptError('ER:01:04');
				}elseif(!$price_id){
					$this->promptError('ER:05:07');
				}

				else{
				
					//Checks the existence of $appcode && $livetoken
					if (!$this->validatesession($appcode,$livetoken))
					{$this->promptError('ER:02:02');}
					
					//Check if Expired..if not yet expired..if not...
					elseif($this->checksessionexpiration($appcode,$livetoken))
					{$this->promptError('ER:03:01');}
					else{	
					
				
						$data['price'] = $this->prices->get($price_id);
							$this->load->view('price_xml', $data);
							
					}
				}

			}
		/* End of GetPriceSectionbyID() */
	
		/* 	GetSectionByID()||CREATE DATE: <11/5/2013>||LAST MODIFIED: <11/5/2013>
			Description: List of Sections and their Seats by Section ID */
		function GetSectionByID(){

			$appcode = $this->input->get_post('appcode');
			$livetoken = $this->input->get_post('livetoken');
			$section_id = $this->input->get_post('id');
			
			if(!$appcode){
				$this->promptError('ER:01:03');
			}elseif(!$livetoken){
				$this->promptError('ER:01:04');
			}elseif(!$section_id){
				$this->promptError('ER:05:05');
			}else{

				//Checks the existence of $appcode && $livetoken
				if (!$this->validatesession($appcode,$livetoken))
				{$this->promptError('ER:02:02');}
				
				//Check if Expired..if not yet expired..if not...
				elseif($this->checksessionexpiration($appcode,$livetoken))
					{ $this->promptError('ER:03:01');}
				else{	

						$data['section'] = $this->sections->get($section_id);


			
						//display the page
						$this->load->view('section_info', $data);
						
						
				
				}
			
		}

		}
		/* End of GetSectionByID() */ 
}

/* End of file generic_mod.php */
/* Location: ./application/controllers/generic_mod.php */



